//TestGreetings.java
//Accesses methods from package misc.greetings in various ways.

//import misc.greetings.*;

/*
Since the misc.greetings package has exactly three classes in it,
the above import statement is equivalent to the following three
import statements:
import misc.greetings.English;
import misc.greetings.French;
import misc.greetings.German;
*/

public class TestGreetings
{
    public static void main(String[] args)
    {
        English.sayHello();
        English.sayHi();
        French.sayBonjour();
        German.sayGutenTag();

        /*
        //The following fully-qualified method calls
        //work without the above import statement.
        misc.greetings.English.sayHello();
        misc.greetings.English.sayHi();
        misc.greetings.French.sayBonjour();
        misc.greetings.German.sayGutenTag();
        */
        
        /*
        //The following method call works if you
        //import just the required package class.
        French.sayBonjour();
        */
    }
}
