/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RulesView
extends JFrame
implements Observer {
    private RulesModel model;
    private RulesController controller;
    private JMenuBar bar = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenu ruleMenu = new JMenu("Rules");
    private JMenuItem exit;
    private JMenuItem clear;
    private JMenuItem GameInfo;
    private JMenuItem GameOrigins;
    private JMenuItem ProgramInfo;
    private JMenuItem CodemakerRules;
    private JMenuItem CodebreakerRules;
    private JScrollPane scrollPane;
    private JTextArea inputTextArea;

    public RulesView(RulesModel rulesModel) {
        super("Mastermind Rules");
        rulesModel.addObserver(this);
        this.model = rulesModel;
        this.controller = new RulesController(this, rulesModel);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RulesView.this.hide();
            }
        };
        this.addWindowListener(windowAdapter);
        this.buildUI();
    }

    private void buildUI() {
        this.fileMenu.setMnemonic('F');
        this.clear = new JMenuItem("Clear Screen");
        this.clear.setMnemonic('C');
        this.fileMenu.add(this.clear);
        this.clear.addActionListener(this.controller);
        this.fileMenu.addSeparator();
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic('E');
        this.fileMenu.add(this.exit);
        this.exit.addActionListener(this.controller);
        this.ruleMenu.setMnemonic('R');
        this.GameInfo = new JMenuItem("GameInfo");
        this.GameInfo.setMnemonic('G');
        this.ruleMenu.add(this.GameInfo);
        this.GameInfo.addActionListener(this.controller);
        this.GameOrigins = new JMenuItem("GameOrigins");
        this.GameOrigins.setMnemonic('O');
        this.ruleMenu.add(this.GameOrigins);
        this.GameOrigins.addActionListener(this.controller);
        this.ProgramInfo = new JMenuItem("ProgramInfo");
        this.ProgramInfo.setMnemonic('P');
        this.ruleMenu.add(this.ProgramInfo);
        this.ProgramInfo.addActionListener(this.controller);
        this.ruleMenu.addSeparator();
        this.CodemakerRules = new JMenuItem("CodemakerRules");
        this.CodemakerRules.setMnemonic('M');
        this.ruleMenu.add(this.CodemakerRules);
        this.CodemakerRules.addActionListener(this.controller);
        this.CodebreakerRules = new JMenuItem("CodebreakerRules");
        this.CodebreakerRules.setMnemonic('B');
        this.ruleMenu.add(this.CodebreakerRules);
        this.CodebreakerRules.addActionListener(this.controller);
        this.setJMenuBar(this.bar);
        this.bar.add(this.fileMenu);
        this.bar.add(this.ruleMenu);
        this.inputTextArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.inputTextArea, 22, 32);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setLocation(200, 150);
        this.setSize(600, 400);
        this.show();
        this.setResizable(false);
    }

    public void update(Observable observable, Object object) {
        StringBuffer stringBuffer = ((RulesModel)observable).getItem();
        this.inputTextArea.setText("");
        this.inputTextArea.append(stringBuffer.toString());
        this.inputTextArea.setCaretPosition(0);
        this.inputTextArea.setEditable(false);
        this.inputTextArea.setBackground(Color.white);
    }

    public void clearTextArea() {
        this.inputTextArea.setText("");
        this.inputTextArea.setCaretPosition(0);
        this.inputTextArea.setEditable(false);
        this.inputTextArea.setBackground(Color.white);
    }
}

