/*
 * Decompiled with CFR 0.152.
 */
import java.util.Observable;
import java.util.Observer;

public class MastermindModel
extends Observable {
    public boolean playAsCodeBreaker = false;
    public boolean playAsCodeMaker = false;
    private UserCodeBreaker userCodeBreaker;
    private ComputerCodeBreaker computerCodeBreaker;
    private int score = 0;
    private int[] guess = new int[4];
    private boolean isValidScore = false;
    private boolean isMaxScore = false;

    public void addObserver(Observer observer) {
        super.addObserver(observer);
    }

    public void playGame() {
        if (this.playAsCodeBreaker) {
            this.userCodeBreaker = new UserCodeBreaker();
        } else if (this.playAsCodeMaker) {
            this.computerCodeBreaker = new ComputerCodeBreaker();
            this.guess = this.computerCodeBreaker.supplyGuess();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public int getCurrentPageNum() {
        if (this.playAsCodeBreaker) {
            return this.userCodeBreaker.getGuessCounter();
        }
        return this.computerCodeBreaker.getGuessCounter();
    }

    public void setCurrentGuess(int[] nArray) {
        this.score = this.userCodeBreaker.getScore(nArray);
        this.setChanged();
        this.notifyObservers();
    }

    public int getScore() {
        return this.score;
    }

    public boolean IsCorrectGuess() {
        return this.userCodeBreaker.IsCorretGuess();
    }

    public void getSecretCode(int[] nArray) {
        this.userCodeBreaker.getComputerSecretCodeAsInt(nArray);
    }

    public int[] getGuess() {
        return this.guess;
    }

    public void setScore(int n) {
        this.computerCodeBreaker.setComputerScore(n);
    }

    public boolean isValidScore() {
        this.isValidScore = this.computerCodeBreaker.isValidScore();
        return this.isValidScore;
    }

    public boolean isMaxScore() {
        this.isMaxScore = this.computerCodeBreaker.isMaxScore();
        return this.isMaxScore;
    }

    public void getNextGuess() {
        this.computerCodeBreaker.filteringPossibleGuesses();
        if (!this.computerCodeBreaker.getError()) {
            this.guess = this.computerCodeBreaker.supplyGuess();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean getError() {
        return this.computerCodeBreaker.getError();
    }
}

