/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

public class MastermindController
implements ActionListener {
    private MastermindView view;
    private MastermindModel model;

    public MastermindController(MastermindView mastermindView, MastermindModel mastermindModel) {
        this.view = mastermindView;
        this.model = mastermindModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("User Code Breaker")) {
            String string = "You will be the code breaker and I will be the code maker.\nPlease click start to play the game.";
            JOptionPane.showMessageDialog(null, string);
            this.view.clearBoard();
            this.model.playAsCodeBreaker = true;
            this.model.playAsCodeMaker = false;
            this.view.enableAsCodeBreaker(false);
        } else if (actionEvent.getActionCommand().equals("User Code Maker")) {
            String string = "You will be the code maker and I will be the code breaker.\nPlease click start to play the game.";
            JOptionPane.showMessageDialog(null, string);
            this.view.clearBoard();
            this.model.playAsCodeBreaker = false;
            this.model.playAsCodeMaker = true;
            this.view.enableAsCodeMaker(false);
        } else if (actionEvent.getActionCommand().equals("Rules")) {
            RulesGUI rulesGUI = new RulesGUI();
        } else if (actionEvent.getActionCommand().equals("On Line Help")) {
            OnlineHelp onlineHelp = new OnlineHelp();
        } else if (actionEvent.getActionCommand().equals("Submit")) {
            if (this.model.playAsCodeBreaker) {
                this.okForCodeBreaker();
            } else if (this.model.playAsCodeMaker) {
                this.okForCodeMaker();
            }
        } else if (actionEvent.getActionCommand().equals("Start")) {
            if (this.model.playAsCodeBreaker) {
                this.view.enableAsCodeBreaker(true);
                this.model.playGame();
                this.view.disableStartBtn();
            } else if (this.model.playAsCodeMaker) {
                this.model.playGame();
                this.view.enableAsCodeMaker(true);
                this.view.disableStartBtn();
            }
        } else if (actionEvent.getActionCommand().equals("QUIT")) {
            System.exit(0);
        } else if (!this.view.checkColorBtn(actionEvent.getSource())) {
            int n = this.model.getCurrentPageNum();
            if (!this.view.checkPageBtn(actionEvent.getSource(), n)) {
                this.view.setScoreBtn(actionEvent.getSource(), n);
            }
        }
    }

    private void okForCodeBreaker() {
        int[] nArray = new int[4];
        int n = this.model.getCurrentPageNum();
        boolean bl = this.view.checkCurrentGuess(nArray, n);
        if (bl) {
            this.model.setCurrentGuess(nArray);
            if (this.model.IsCorrectGuess()) {
                String string = "Congratulations! Victory in " + this.model.getCurrentPageNum() + (this.model.getCurrentPageNum() == 1 ? " guess." : " guesses.");
                JOptionPane.showMessageDialog(null, string);
            } else if (this.model.getCurrentPageNum() < 10) {
                this.view.enableCurrPage(this.model.getCurrentPageNum());
            } else {
                String string = "Sorry, you've used up all your guesses,\ncheck the secret code. Play again.";
                JOptionPane.showMessageDialog(null, string);
                this.view.showSecretCode();
            }
        } else {
            String string = "Sorry,you should provide a valid guess.\nPlease, try again!";
            JOptionPane.showMessageDialog(null, string);
        }
    }

    private void okForCodeMaker() {
        int n = this.model.getCurrentPageNum();
        int n2 = this.view.getCurrentScore(n);
        this.model.setScore(n2);
        boolean bl = this.model.isValidScore();
        boolean bl2 = this.model.isMaxScore();
        if (bl) {
            if (bl2) {
                String string = "Congratulations! to me, Victory in " + (this.model.getCurrentPageNum() + 1) + (this.model.getCurrentPageNum() + 1 == 1 ? " guess." : " guesses.");
                JOptionPane.showMessageDialog(null, string);
                this.view.clearBoard();
            } else if (this.model.getCurrentPageNum() < 10) {
                boolean bl3 = false;
                boolean bl4 = true;
                this.view.disableOrEnableScore(bl3, this.model.getCurrentPageNum());
                this.model.getNextGuess();
                if (this.model.getError()) {
                    String string = "Something seems to be wrong!\nAre you sure you scored correctly?\nCheck your scoring. Play agian ...";
                    JOptionPane.showMessageDialog(null, string);
                    this.view.disableOrEnableScore(bl3, this.model.getCurrentPageNum());
                    this.view.disableOkBtn();
                } else {
                    this.view.disableOrEnableScore(bl4, this.model.getCurrentPageNum());
                }
            } else {
                String string = "Sorry, I've used up all my guesses,\nYour secret code seemes hard for me to guess!";
                JOptionPane.showMessageDialog(null, string);
                this.view.clearBoard();
            }
        } else {
            String string = "Your score is not valid, check your \nscore and try again.";
            JOptionPane.showMessageDialog(null, string);
        }
    }
}

