/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;

public class ComputerCodeBreaker {
    private static final int MAX_SCORE = 40;
    private static final int MAX_NUM_GUESSES = 10;
    private static final int MAX_TRIES = 3;
    private static final int NUM_PAGES = 4;
    private static final int NUM_COLORS = 8;
    private static final String[] POSSIBLE_SCORES = new String[]{"00", "01", "02", "03", "04", "10", "11", "12", "13", "20", "21", "22", "30", "40"};
    private static int score = 0;
    private static int guessCounter = 0;
    private static boolean validCode = false;
    private static boolean validScore = false;
    private static boolean correctGuess = false;
    private static boolean error = false;
    private static Vector possibleGuesses = new Vector(0);
    private static StringBuffer[] computerGuesses = new StringBuffer[10];
    private static StringBuffer[] computerScore = new StringBuffer[10];

    private void generatePossibleGuesses() {
        possibleGuesses.removeAllElements();
        int n = 1;
        while (n <= 8) {
            int n2 = 1;
            while (n2 <= 8) {
                int n3 = 1;
                while (n3 <= 8) {
                    int n4 = 1;
                    while (n4 <= 8) {
                        String string = String.valueOf(n) + String.valueOf(n2) + String.valueOf(n3) + String.valueOf(n4);
                        possibleGuesses.addElement(string);
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void reset() {
        validCode = false;
        correctGuess = false;
        validScore = false;
        error = false;
        score = 0;
        int n = 0;
        while (n <= guessCounter) {
            if (computerGuesses[n] != null) {
                computerGuesses[n].setLength(0);
            }
            if (computerScore[n] != null) {
                computerScore[n].setLength(0);
            }
            ++n;
        }
        guessCounter = 0;
    }

    public ComputerCodeBreaker() {
        this.reset();
        this.generatePossibleGuesses();
        this.generateFirstGuess();
    }

    public StringBuffer getCurrentGuess() {
        return computerGuesses[guessCounter];
    }

    private void generateFirstGuess() {
        Random random = new Random();
        ComputerCodeBreaker.computerGuesses[0] = new StringBuffer("");
        int n = 0;
        while (n < 4) {
            int n2 = random.nextInt(8) + 1;
            computerGuesses[0].append(n2);
            ++n;
        }
    }

    public int getGuessCounter() {
        return guessCounter;
    }

    public int[] supplyGuess() {
        int[] nArray = new int[4];
        String string = new String("");
        int n = 0;
        while (n < nArray.length) {
            string = string + computerGuesses[guessCounter].charAt(n);
            nArray[n] = Integer.parseInt(string);
            string = "";
            ++n;
        }
        return nArray;
    }

    public void setComputerScore(int n) {
        ComputerCodeBreaker.computerScore[ComputerCodeBreaker.guessCounter] = new StringBuffer("");
        computerScore[guessCounter].append(n / 10);
        computerScore[guessCounter].append(n % 10);
    }

    public boolean isValidScore() {
        String string = computerScore[guessCounter].toString();
        int n = 0;
        while (n < POSSIBLE_SCORES.length) {
            if (string.equals(POSSIBLE_SCORES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isMaxScore() {
        correctGuess = computerScore[guessCounter].toString().equals(POSSIBLE_SCORES[13]);
        return correctGuess;
    }

    public void filteringPossibleGuesses() {
        boolean bl = false;
        int n = 0;
        while (n < possibleGuesses.size() && !bl) {
            if (possibleGuesses.elementAt(n).equals(computerGuesses[guessCounter].toString())) {
                possibleGuesses.removeElementAt(n);
                bl = true;
            }
            ++n;
        }
        if (POSSIBLE_SCORES[0].equals(computerScore[guessCounter].toString())) {
            this.filteringCase_00();
        }
        if (POSSIBLE_SCORES[1].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightColorButNotRightPosition(1);
        }
        if (POSSIBLE_SCORES[2].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightColorButNotRightPosition(2);
        }
        if (POSSIBLE_SCORES[3].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightColorButNotRightPosition(3);
        }
        if (POSSIBLE_SCORES[4].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightColorButNotRightPosition(4);
        }
        if (POSSIBLE_SCORES[5].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPosition(1);
        }
        if (POSSIBLE_SCORES[9].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPosition(2);
        }
        if (POSSIBLE_SCORES[12].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPosition(3);
        }
        if (POSSIBLE_SCORES[6].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPositionAndRightColor(1, 1);
        }
        if (POSSIBLE_SCORES[7].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPositionAndRightColor(1, 2);
        }
        if (POSSIBLE_SCORES[8].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPositionAndRightColor(1, 3);
        }
        if (POSSIBLE_SCORES[10].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPositionAndRightColor(2, 1);
        }
        if (POSSIBLE_SCORES[11].equals(computerScore[guessCounter].toString())) {
            this.filteringCaseForRightPositionAndRightColor(2, 2);
        }
        if (possibleGuesses.isEmpty()) {
            error = true;
            return;
        }
        this.selectNextGuess();
    }

    private void filteringCase_00() {
        int n = 0;
        while (n < possibleGuesses.size()) {
            StringBuffer stringBuffer = new StringBuffer(possibleGuesses.elementAt(n).toString());
            boolean bl = false;
            int n2 = 0;
            while (n2 < 4 && !bl) {
                int n3 = 0;
                while (n3 < 4 && !bl) {
                    if (computerGuesses[guessCounter].charAt(n2) == stringBuffer.charAt(n3)) {
                        possibleGuesses.removeElementAt(n);
                        bl = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (bl) continue;
            ++n;
        }
    }

    private void filteringCaseForRightColorButNotRightPosition(int n) {
        int n2 = 0;
        while (n2 < possibleGuesses.size()) {
            StringBuffer stringBuffer = new StringBuffer(possibleGuesses.elementAt(n2).toString());
            int n3 = 0;
            int n4 = 0;
            while (n4 < 4 && n3 < n) {
                int n5 = 0;
                while (n5 < 4 && n3 < n) {
                    if (computerGuesses[guessCounter].charAt(n4) == stringBuffer.charAt(n5) && n4 != n5) {
                        ++n3;
                    }
                    ++n5;
                }
                ++n4;
            }
            if (n3 == n) {
                ++n2;
                continue;
            }
            possibleGuesses.removeElementAt(n2);
        }
    }

    private void filteringCaseForRightPosition(int n) {
        int n2 = 0;
        while (n2 < possibleGuesses.size()) {
            StringBuffer stringBuffer = new StringBuffer(possibleGuesses.elementAt(n2).toString());
            int n3 = 0;
            int n4 = 0;
            while (n4 < 4 && n3 < n) {
                if (computerGuesses[guessCounter].charAt(n4) == stringBuffer.charAt(n4)) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 == n) {
                ++n2;
                continue;
            }
            possibleGuesses.removeElementAt(n2);
        }
    }

    private void filteringCaseForRightPositionAndRightColor(int n, int n2) {
        int n3 = 0;
        while (n3 < possibleGuesses.size()) {
            StringBuffer stringBuffer = new StringBuffer(possibleGuesses.elementAt(n3).toString());
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < 4 && (n4 < n || n5 < n2)) {
                if (computerGuesses[guessCounter].charAt(n6) == stringBuffer.charAt(n6)) {
                    ++n4;
                }
                int n7 = 0;
                while (n7 < 4 && (n4 < n || n5 < n2)) {
                    if (computerGuesses[guessCounter].charAt(n6) == stringBuffer.charAt(n7) && n6 != n7) {
                        ++n5;
                    }
                    ++n7;
                }
                ++n6;
            }
            if (n4 >= n && n5 >= n2) {
                ++n3;
                continue;
            }
            possibleGuesses.removeElementAt(n3);
        }
    }

    private void selectNextGuess() {
        int n = 0;
        while (n < possibleGuesses.size()) {
            StringBuffer stringBuffer = new StringBuffer(possibleGuesses.elementAt(n).toString());
            boolean bl = true;
            int n2 = 0;
            while (n2 <= guessCounter && bl) {
                bl = this.isSameScore(stringBuffer, n2);
                ++n2;
            }
            if (bl) {
                ComputerCodeBreaker.computerGuesses[++ComputerCodeBreaker.guessCounter] = new StringBuffer(stringBuffer.toString());
                return;
            }
            ++n;
        }
        error = true;
    }

    private boolean isSameScore(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = new StringBuffer(computerGuesses[n].toString());
        StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.toString());
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            if (computerGuesses[n].charAt(n3) == stringBuffer.charAt(n3)) {
                n2 += 10;
                stringBuffer2.setCharAt(n3, '0');
                stringBuffer3.setCharAt(n3, '0');
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 4 && n2 < 40) {
            int n5 = 0;
            while (n5 < 4 && stringBuffer3.charAt(n4) != '0') {
                if (stringBuffer3.charAt(n4) == stringBuffer2.charAt(n5)) {
                    ++n2;
                    stringBuffer2.setCharAt(n5, '0');
                    stringBuffer3.setCharAt(n4, '0');
                }
                ++n5;
            }
            ++n4;
        }
        Integer n6 = new Integer(computerScore[n].toString());
        return n2 == n6;
    }

    public boolean getError() {
        return error;
    }
}

