/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Menu {
    private static final int MAX_TITLE_LENGTH = 60;
    private static final int MAX_OPTION_LENGTH = 60;
    private static final int MAX_NUM_OPTIONS = 20;
    private int numberOfOptions = 0;
    private String[] menuText = new String[21];
    private static BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
    private static PrintWriter screen = new PrintWriter(System.out, true);

    private static void pause() throws IOException {
        screen.print("Press Enter to continue ... ");
        screen.flush();
        keyboard.readLine();
    }

    private boolean isDigitChar(char c) {
        return c >= '0' && c <= '9';
    }

    public Menu() {
        this.menuText[0] = "Empty Menu";
    }

    public Menu(String string) throws IOException {
        if (string.length() > 60) {
            this.menuText[0] = "Empty Menu";
            screen.println("\n===== Error: Maximum length of menu title exceeded.\nThe title\n\n<<" + string + ">>\n" + "\nwas not added to the menu.\n" + "\nThis menu has been given the default title:" + "\nEmpty Menu\n");
            Menu.pause();
            return;
        }
        this.menuText[0] = string;
    }

    public void setTitle(String string) throws IOException {
        if (string.length() > 60) {
            screen.println("\n===== Error: Maximum length of menu title exceeded.\nThe title on the following line was not added to the menu:\n" + string + "\n");
            Menu.pause();
            return;
        }
        this.menuText[0] = string;
    }

    public void addOption(String string) throws IOException {
        if (this.numberOfOptions == 20) {
            screen.println("\n===== Error: Maximum number of menu options exceeded.\nOption <<" + string + ">> not added.");
            Menu.pause();
            return;
        }
        if (string.length() > 60) {
            screen.println("\n===== Error: Maximum length of menu option exceeded.\nThe option\n\n<<" + string + ">>\n" + "\nwas not added to the menu.");
            Menu.pause();
            return;
        }
        ++this.numberOfOptions;
        if (this.numberOfOptions == 10) {
            int n = 1;
            while (n < this.numberOfOptions) {
                this.menuText[n] = " " + this.menuText[n];
                ++n;
            }
        }
        String string2 = new Integer(this.numberOfOptions).toString();
        string2 = string2 + ". ";
        this.menuText[this.numberOfOptions] = string2 = string2 + string;
    }

    public void display() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 1;
        while (n6 <= (24 - this.numberOfOptions - 2) / 2 + 15) {
            screen.println();
            ++n6;
        }
        if (this.numberOfOptions == 0) {
            n5 = 0;
            n4 = 0;
        } else {
            n3 = 0;
            n2 = 0;
            n = 1;
            while (n <= this.numberOfOptions) {
                if (this.menuText[n].length() > n3) {
                    n3 = this.menuText[n].length();
                }
                n2 += this.menuText[n].length();
                ++n;
            }
            int n7 = n2 / this.numberOfOptions;
            int n8 = this.menuText[0].length();
            n5 = 38 - (n8 + 1) / 2;
            n4 = 38 - (n3 + 1) / 2;
        }
        n3 = 1;
        while (n3 <= n5) {
            screen.print(" ");
            ++n3;
        }
        screen.println(this.menuText[0] + "\n");
        if (this.numberOfOptions == 0) {
            screen.println("This menu currently has no options ... ");
        }
        n2 = 1;
        while (n2 <= this.numberOfOptions) {
            n = 1;
            while (n <= n4) {
                screen.print(" ");
                ++n;
            }
            screen.println(this.menuText[n2]);
            ++n2;
        }
        n = 1;
        while (n <= (24 - this.numberOfOptions - 2) / 2) {
            screen.println();
            ++n;
        }
    }

    public int getChoice() throws IOException {
        int n;
        boolean bl;
        String string = new String("Enter number of your menu choice here and then press Enter: ");
        int n2 = 0;
        if (this.numberOfOptions == 0) {
            screen.println("\n===== Error: Menu has no options from which to choose.");
            Menu.pause();
            return -1;
        }
        screen.print("          " + string);
        screen.flush();
        do {
            String string2 = new String(keyboard.readLine());
            ++n2;
            if (string2.equals("")) {
                bl = false;
                n = 0;
            } else {
                boolean bl2;
                bl = false;
                if (this.numberOfOptions < 10) {
                    bl2 = string2.length() == 1;
                } else {
                    boolean bl3 = bl2 = string2.length() <= 2;
                }
                if (string2.length() == 1) {
                    bl = this.isDigitChar(string2.charAt(0));
                } else if (string2.length() == 2) {
                    boolean bl4 = bl = this.isDigitChar(string2.charAt(0)) && this.isDigitChar(string2.charAt(1));
                }
                if (bl) {
                    n = new Integer(string2);
                    bl = bl2 && n >= 1 && n <= this.numberOfOptions;
                } else {
                    n = 0;
                }
            }
            if (bl || n2 >= 3) continue;
            screen.print("===== Error: Sorry! Invalid response.\nPlease try again: ");
            screen.flush();
        } while (!bl && n2 < 3);
        if (!bl && n2 == 3) {
            screen.println("===== Error: Sorry, but you only get 3 chances.");
            Menu.pause();
            return -1;
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        Menu menu = new Menu("A New Menu");
        menu.addOption("Quit");
        menu.addOption("Get information");
        menu.addOption("Do something");
        menu.display();
        do {
            menu.display();
            n = menu.getChoice();
            switch (n) {
                case -1: 
                case 1: {
                    screen.println("Program now terminating.");
                    Menu.pause();
                    break;
                }
                case 2: {
                    screen.println("Getting information ... ");
                    Menu.pause();
                    break;
                }
                case 3: {
                    screen.println("Doing something ... ");
                    Menu.pause();
                }
            }
        } while (n != -1 && n != 1);
    }
}

