/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class MMGame {
    private static BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
    private static PrintWriter screen = new PrintWriter(System.out, true);
    private static final int CODE_SIZE = 4;
    private static final int NUM_COLORS = 8;
    private static final int MAX_SCORE = 40;
    private static final int MAX_GUESSES = 10;
    private static final int MAX_RESPONSES = 3;
    private static StringBuffer randomCode;
    private static StringBuffer secretCode;
    private static StringBuffer guess;
    private static boolean randOK;
    private static boolean guessOK;
    private static int guessCount;
    private static int scoreOfMostRecentGuess;
    boolean secretCodeFound;
    private static final String MAX_CODE = "8888";
    private static final String MID_CODE = "4444";
    private static final String MIN_CODE = "1111";
    private static final int MAX_SCORES = 10;
    private static boolean okToOffer;
    private static boolean scoreOK;
    private static boolean trulyRandom;
    private static int[] scores;
    private static StringBuffer[] guesses;
    private static int numEndPointsSeen;
    private static int direction;

    private static void pause() throws IOException {
        screen.print("Press Enter to continue ... ");
        screen.flush();
        keyboard.readLine();
    }

    public void play() throws IOException {
        int n;
        Menu menu = new Menu("Play Menu");
        menu.addOption("Return to Main Menu");
        menu.addOption("You be the Codebreaker");
        menu.addOption("You be the Codemaker");
        do {
            menu.display();
            n = menu.getChoice();
            switch (n) {
                case -1: {
                    screen.println("\nNow returning to main menu.\n");
                    MMGame.pause();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.computerMakesUserBreaks();
                    break;
                }
                case 3: {
                    this.userMakesComputerBreaks();
                }
            }
        } while (n != 1 && n != -1);
    }

    private void computerMakesUserBreaks() throws IOException {
        int n;
        Menu menu = new Menu("Codebreaker Menu");
        menu.addOption("Return to Play Menu");
        menu.addOption("Play Codebreaker again");
        MMInfo.mmText.displayItem("CodebreakerRules");
        do {
            guessCount = 0;
            this.getRandomCode();
            if (randOK) {
                secretCode = new StringBuffer(randomCode.toString());
                if (trulyRandom) {
                    screen.println("OK, you've generated a random secret code.");
                } else {
                    screen.println("OK, we'll use the \"random\" code you've supplied.");
                }
            } else {
                screen.println("\nError: Bad Random Code");
                screen.println("Returning to Play Menu");
                MMGame.pause();
                return;
            }
            MMGame.pause();
            do {
                this.getUserGuess();
                if (guessOK) continue;
                screen.println("Returning to Play Menu");
                MMGame.pause();
                return;
            } while ((scoreOfMostRecentGuess = this.score(secretCode, guess)) != 40 && guessCount != 10);
            if (scoreOfMostRecentGuess == 40) {
                if (guessCount != 1) {
                    screen.println();
                }
                screen.println("Congratulations! Victory in " + guessCount + (guessCount == 1 ? " guess." : " guesses."));
                MMGame.pause();
            } else if (guessCount == 10) {
                screen.println("Sorry, you've used up all your guesses, but here's the secret code: " + secretCode);
                MMGame.pause();
            }
            menu.display();
            n = menu.getChoice();
            if (n != -1) continue;
            screen.println("Returning to Play Menu");
            MMGame.pause();
            return;
        } while (n == 2);
    }

    private void getUserGuess() throws IOException {
        int n = 0;
        if (guessCount == 0) {
            screen.print("\nSecret code is ****                   First guess? ");
            screen.flush();
        } else {
            screen.print("Guess  #" + guessCount + " is " + guess + "   Score is " + scoreOfMostRecentGuess / 10 + scoreOfMostRecentGuess % 10 + "        Next guess? ");
            screen.flush();
        }
        do {
            StringBuffer stringBuffer;
            String string = keyboard.readLine();
            if (guessCount == 0 && ++n == 1) {
                screen.println();
            }
            if (guessOK = MMGame.codeValid(stringBuffer = new StringBuffer(string))) {
                guess = new StringBuffer();
                guess.setLength(0);
                guess.append(string);
                continue;
            }
            if (n >= 3) continue;
            if (guessCount > 0 && n == 1) {
                screen.println();
            }
            screen.print("Sorry!  Invalid response. Please try again: ");
            screen.flush();
        } while (!guessOK && n != 3);
        if (guessOK) {
            ++guessCount;
            if (n > 1) {
                screen.println();
            }
        } else if (n == 3) {
            screen.println("Error: Too Many Bad Guesses\nOnly three attempts to enter a valid guess are permitted.");
            MMGame.pause();
        }
    }

    private void getRandomCode() throws IOException {
        MMInfo.mmText.displayItem("RandomCodeEntryOrGenerationRules");
        screen.print("\nEnter the \"random\" code here, or just press Enter to generate one: ");
        screen.flush();
        String string = keyboard.readLine();
        if (!string.equals("")) {
            StringBuffer stringBuffer = new StringBuffer(string);
            randOK = MMGame.codeValid(stringBuffer);
            if (randOK) {
                randomCode = new StringBuffer(string);
            }
            trulyRandom = false;
        } else {
            char[] cArray = new char[]{'1', '2', '3', '4', '5', '6', '7', '8'};
            randomCode = new StringBuffer("xxxx");
            int n = 0;
            while (n < 4) {
                int n2 = (int)(80.0 * Math.random()) / 10;
                randomCode.setCharAt(n, cArray[n2]);
                ++n;
            }
            randOK = true;
            trulyRandom = true;
        }
    }

    private int score(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            if (stringBuffer2.charAt(n3) == stringBuffer.charAt(n3)) {
                ++n2;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 1;
        while (n5 <= 8) {
            int n6 = 0;
            int n7 = 0;
            n = 0;
            while (n < 4) {
                if (stringBuffer.charAt(n) == (char)(n5 + 48)) {
                    ++n6;
                }
                if (stringBuffer2.charAt(n) == (char)(n5 + 48)) {
                    ++n7;
                }
                ++n;
            }
            n4 = n6 <= n7 ? (n4 += n6) : (n4 += n7);
            ++n5;
        }
        n = n4 - n2;
        return n2 * 10 + n;
    }

    private static boolean codeValid(StringBuffer stringBuffer) {
        boolean bl;
        boolean bl2 = bl = stringBuffer.length() == 4;
        if (bl) {
            int n = 0;
            while (n < 4) {
                if (stringBuffer.charAt(n) < '1' || stringBuffer.charAt(n) > '8') {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    void userMakesComputerBreaks() throws IOException {
        int n;
        Menu menu = new Menu("Codemaker Menu");
        menu.addOption("Return to Play Menu");
        menu.addOption("Play Codemaker again");
        MMInfo.mmText.displayItem("CodemakerRules");
        do {
            this.searchForSecretCode();
            if (!this.secretCodeFound) {
                if (randOK) {
                    screen.println("Returning to Play Menu");
                    MMGame.pause();
                }
                return;
            }
            screen.println("\nCongratulations to me! I guessed correctly in " + guessCount + (guessCount == 1 ? " guess." : " guesses."));
            MMGame.pause();
            menu.display();
            n = menu.getChoice();
            switch (n) {
                case -1: 
                case 1: {
                    screen.println("\nNow returning to Play Menu.\n");
                    MMGame.pause();
                    break;
                }
                case 2: {
                    screen.println("\nOK. Choose your next secret code, write it down, and when you are ready ...\n");
                    MMGame.pause();
                }
            }
        } while (n == 2);
    }

    boolean scoreValid(StringBuffer stringBuffer) {
        boolean bl = stringBuffer.length() != 2 || stringBuffer.charAt(0) == '3' && stringBuffer.charAt(1) == '1' || stringBuffer.charAt(0) < '0' || stringBuffer.charAt(0) > '4' || stringBuffer.charAt(1) < '0' || stringBuffer.charAt(1) > '4' || stringBuffer.charAt(0) - 48 + stringBuffer.charAt(1) - 48 > 4;
        return !bl;
    }

    void increment(StringBuffer stringBuffer) {
        stringBuffer.setCharAt(3, (char)(stringBuffer.charAt(3) + '\u0001'));
        if (stringBuffer.charAt(3) > '8') {
            stringBuffer.setCharAt(3, '1');
            stringBuffer.setCharAt(2, (char)(stringBuffer.charAt(2) + '\u0001'));
            if (stringBuffer.charAt(2) > '8') {
                stringBuffer.setCharAt(2, '1');
                stringBuffer.setCharAt(1, (char)(stringBuffer.charAt(1) + '\u0001'));
                if (stringBuffer.charAt(1) > '8') {
                    stringBuffer.setCharAt(1, '1');
                    stringBuffer.setCharAt(0, (char)(stringBuffer.charAt(0) + '\u0001'));
                    if (stringBuffer.charAt(0) > '8') {
                        stringBuffer.setCharAt(0, '1');
                    }
                }
            }
        }
    }

    void decrement(StringBuffer stringBuffer) {
        stringBuffer.setCharAt(3, (char)(stringBuffer.charAt(3) - '\u0001'));
        if (stringBuffer.charAt(3) < '1') {
            stringBuffer.setCharAt(3, '8');
            stringBuffer.setCharAt(2, (char)(stringBuffer.charAt(2) - '\u0001'));
            if (stringBuffer.charAt(2) < '1') {
                stringBuffer.setCharAt(2, '8');
                stringBuffer.setCharAt(1, (char)(stringBuffer.charAt(1) - '\u0001'));
                if (stringBuffer.charAt(1) < '1') {
                    stringBuffer.setCharAt(1, '8');
                    stringBuffer.setCharAt(0, (char)(stringBuffer.charAt(0) - '\u0001'));
                    if (stringBuffer.charAt(0) < '1') {
                        stringBuffer.setCharAt(0, '8');
                    }
                }
            }
        }
    }

    void searchForSecretCode() throws IOException {
        this.getRandomCode();
        if (randOK) {
            MMGame.guesses[0] = new StringBuffer(randomCode.toString());
            guessCount = 1;
            if (trulyRandom) {
                screen.println("OK, I'll use a random starting guess.");
            } else {
                screen.println("OK, I'll use the starting guess you've supplied.");
            }
        } else {
            screen.println("\nError: Bad Random Code");
            screen.println("Returning to Play Menu");
            MMGame.pause();
            this.secretCodeFound = false;
            return;
        }
        MMGame.pause();
        numEndPointsSeen = guesses[0].toString().equals(MIN_CODE.toString()) || guesses[0].toString().equals(MAX_CODE.toString()) ? 1 : 0;
        direction = guesses[0].toString().compareTo(MID_CODE.toString()) <= 0 ? 1 : -1;
        boolean bl = false;
        boolean bl2 = false;
        this.getUserScore();
        while (!this.secretCodeFound && scoreOK && !bl2 && !bl) {
            this.getNextCandidate();
            if (okToOffer) {
                this.getUserScore();
            }
            bl2 = guessCount == 10;
            boolean bl3 = bl = numEndPointsSeen == 2 && !this.secretCodeFound;
            if (bl2 && !this.secretCodeFound) {
                MMInfo.mmText.displayItem("Apology");
            }
            if (!bl) continue;
            MMInfo.mmText.displayItem("Error: UserScoredIncorrectly");
        }
    }

    void getUserScore() throws IOException {
        String string;
        int n = 0;
        if (guessCount == 1) {
            screen.println();
        }
        screen.print("My guess " + (guessCount == 10 ? "#" : " #") + guessCount + " is: " + guesses[guessCount - 1].toString() + "." + " Please enter my score: ");
        screen.flush();
        do {
            StringBuffer stringBuffer;
            if ((scoreOK = this.scoreValid(stringBuffer = new StringBuffer(string = keyboard.readLine()))) || ++n >= 3) continue;
            screen.println();
            screen.print("Sorry! Invalid response. Please try again: ");
            screen.flush();
        } while (!scoreOK && n != 3);
        if (scoreOK) {
            if (n > 1) {
                screen.println();
            }
            MMGame.scores[MMGame.guessCount - 1] = 10 * (string.charAt(0) - 48) + string.charAt(1) - 48;
            this.secretCodeFound = scores[guessCount - 1] == 40;
        } else {
            screen.println("Sorry! Only three attempts to enter a valid score are permitted.");
            this.secretCodeFound = false;
        }
    }

    void getNextCandidate() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("xxxx");
        if (numEndPointsSeen == 0) {
            direction = -direction;
            stringBuffer = guessCount == 1 ? new StringBuffer(guesses[0].toString()) : new StringBuffer(guesses[guessCount - 2].toString());
        }
        if (numEndPointsSeen == 1) {
            stringBuffer = new StringBuffer(guesses[guessCount - 1].toString());
        }
        do {
            if (direction == 1) {
                this.increment(stringBuffer);
            }
            if (direction == -1) {
                this.decrement(stringBuffer);
            }
            boolean bl2 = bl = stringBuffer.toString().equals(MAX_CODE.toString()) || stringBuffer.toString().equals(MIN_CODE.toString());
            if (bl) {
                ++numEndPointsSeen;
            }
            okToOffer = true;
            int n = 0;
            while (n < guessCount) {
                int n2 = this.score(stringBuffer, guesses[n]);
                if (n2 != scores[n]) {
                    okToOffer = false;
                }
                ++n;
            }
        } while (!okToOffer && !bl);
        if (okToOffer) {
            MMGame.guesses[MMGame.guessCount++] = new StringBuffer(stringBuffer.toString());
        }
        if (bl) {
            direction = -direction;
        }
    }

    static {
        scores = new int[10];
        guesses = new StringBuffer[10];
    }
}

